@extends('layouts.adminlayout')
@section('title','CARRISOFT V2: BON DE COMMANDE')


@section('content')
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;">
        <div class="col-12 col-sm-12 col-md-12">
            <h5 class="ml-5">{{__('messages.INVENTAIRE GLOBAL')}}</h5>
        </div>
        <br>

        <div class="info-box mb-1 flex-column">
            <div class="d-flex align-items-center ">
                <div class="col-12 col-md-3 text-center">
                    <label class="font-weight-normal">Date debut </label>
                    <input type="date" name="from_date" id="from_date" class="form-control"/>
                </div>
                <div class="col-12 col-md-3 text-center">
                    <label class="font-weight-normal">Date fin </label>
                    <input type="date" name="to_date" id="to_date" class="form-control"/>
                </div>
                <div class="col-12 col-md-6" style="margin-top: 30px">
                    <button type="button" name="filter" id="filter" class="btn btn-warning">{{__('messages.Rechercher')}}</button>
                    <button type="button" name="imprimer" id="imprimer" class="btn btn-primary">{{__('messages.Imprimer')}}</button>
                    <button type="button" name="refresh" id="reset" class="btn btn-danger">{{__('messages.Actualiser')}}</button>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="info-box">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered" id="inventaires">
                        <thead>
                        <tr class="cart_menu" style="font-size: 14px">
                            <td class="price">{{__('messages.Produit')}}</td>
                            <td class="price">{{__('messages.Qte initiale')}}</td>
                            <td class="price">{{__('messages.Qte recue')}}</td>
                            <td class="price">{{__('messages.Qte totale')}}</td>
                            <td class="price">{{__('messages.Qte sortie')}}</td>
                            <td class="price">{{__('messages.Qte theorique dispo')}}</td>
                            <td class="price">{{__('messages.Qte restante')}}</td>
                            <td class="price">{{__('messages.Ecart a l\'inventaire')}}</td>
                            <td class="price">{{__('messages.Qte empruntee')}}</td>
                            <td class="price">{{__('messages.Qte pretee')}}</td>
                            <td class="price">{{__('messages.Perte du mois')}}</td>
                            <td class="price">{{__('messages.Qte avariee/cassee')}}</td>
                            <td class="price">{{__('messages.Qte perimee')}}</td>
                            <td class="price">{{__('messages.Autres')}}</td>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>


    </main>
@endsection

@section('extra-js')
    <script>
        $(document).ready(function(){
            $('.input-daterange').datepicker({
                todayBtn:'linked',
                format:'yyyy-mm-dd',
                autoclose:true
            });

            load_data();

            function load_data(from_date = '', to_date = '') {
                pdt_magDataTable = $('#inventaires').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url:'{{ route("inv.invglobal") }}',
                        data:{from_date:from_date, to_date:to_date}
                    },
                    columns: [
                        {
                            data:'libelle',
                            name:'libelle'
                        },
                        {
                            data:'qte_debut',
                            name:'qte_debut'
                        },
                        {
                            data:'qte_recue',
                            name:'qte_recue'
                        },
                        {
                            data:'qte_totale',
                            name:'qte_totale'
                        },
                        {
                            data:'qte_sortie',
                            name:'qte_sortie'
                        },
                        {
                            data:'qte_theorique',
                            name:'qte_theorique'
                        },
                        {
                            data:'qte_comptee',
                            name:'qte_comptee',
                        },
                        {
                            data:'ecart_inventaire',
                            name:'ecart_inventaire'
                        },
                        {
                            data:'qte_emprunt',
                            name:'qte_emprunt'
                        },
                        {
                            data:'qte_pret',
                            name:'qte_pret'
                        },
                        {
                            data:'qte_perdue',
                            name:'qte_perdue'
                        },
                        {
                            data:'qte_avariee',
                            name:'qte_avariee'
                        },
                        {
                            data:'qte_perimee',
                            name:'qte_perimee'
                        },
                        {
                            data:'autres_qte',
                            name:'autres_qte'
                        },
                    ]
                });
            }

            $('#filter').click(function(){
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();
                if(from_date != '' && to_date != '')
                {
                    $('#inventaires').DataTable().destroy();
                    load_data(from_date, to_date);
                }
                else
                {
                    alert('{{__('messages.Selectionner la periode')}}');
                }
            });

            $('#reset').click(function(){
                $('#from_date').val('');
                $('#to_date').val('');
                $('#inventaires').DataTable().destroy();
                load_data();
            });

            $('#imprimer').click(function(){
                var debut = document.getElementById('from_date').value;
                var fin = document.getElementById('to_date').value;

                var newWin = window.open();
                var the_url = "inv.print_invglobal/"+debut+"/"+fin;
                $.ajax({
                    type: "GET", url: the_url, data: {},
                    success: function(data){
                        newWin.document.write(data);;
                    }
                    ,error: function() {
                    }
                });
            });

        });
    </script>
@endsection
